
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1221.C - Message 1221 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1221 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1221.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:04   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:52:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:44   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 14:08:56   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:12   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1221 message from the ZMsgBuf.
//
void Dec1221(tMSGBUF *ZMsgBuf, tMSG1221 *Msg)
{  
   GetBit(&NavCfgBits.DisableHeldAltitude  , ZMsgBuf, 7,0);  // 1=disable
   GetBit(&NavCfgBits.DisableGTSmoothing   , ZMsgBuf, 7,1);  // 1=disable
   GetBit(&NavCfgBits.DisablePosPinning    , ZMsgBuf, 7,2);  // 1=disable
   GetBit(&NavCfgBits.DisableLowQualityMeas, ZMsgBuf, 7,3);  // 1=disable
   GetBit(&NavCfgBits.EnableJammingDetect  , ZMsgBuf, 7,4);  // 1=enable
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1221 message in the ZMsgBuf.
//
void Bld1221(tMSGBUF *ZMsgBuf, tMSG1221 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                      , ZMsgBuf, 1);    // message preamble
   PutShort  (1221                        , ZMsgBuf, 2);    // message number
   PutShort  (9                           , ZMsgBuf, 3);    // message length
   PutShort  (ANREQ                       , ZMsgBuf, 4);    // message ack/nack request

   PutBit(NavCfgBits.DisableHeldAltitude  , ZMsgBuf, 7,0);  // 1=disable
   PutBit(NavCfgBits.DisableGTSmoothing   , ZMsgBuf, 7,1);  // 1=disable
   PutBit(NavCfgBits.DisablePosPinning    , ZMsgBuf, 7,2);  // 1=disable
   PutBit(NavCfgBits.DisableLowQualityMeas, ZMsgBuf, 7,3);  // 1=disable
   PutBit(NavCfgBits.EnableJammingDetect  , ZMsgBuf, 7,4);  // 1=enable
}
